export default async function saveSignature(request) {
  const { signature, userId, initials, id, title, stamp } = request.params;

  if (!userId) {
    throw new Parse.Error(Parse.Error.INVALID_QUERY, 'Missing userId parameter.');
  }
  if (userId !== request.user?.id) {
    throw new Parse.Error(Parse.Error.INVALID_QUERY, 'Cannot save signature for the current user.');
  }
  const userPtr = { __type: 'Pointer', className: '_User', objectId: userId };
  try {
    const signatureCls = new Parse.Object('contracts_Signature');
    if (id) {
      signatureCls.id = id;
    }
    if (initials) {
      signatureCls.set('Initials', initials);
    }
    if (signature) {
      signatureCls.set('ImageURL', signature);
    }
    if (stamp) {
      signatureCls.set('Stamp', stamp);
    }
    if (title) {
      signatureCls.set('SignatureName', title);
    }
    if (userPtr) {
      signatureCls.set('UserId', userPtr);
    }
    const signRes = await signatureCls.save(null, { useMasterKey: true });
    return signRes;
  } catch (err) {
    throw err;
  }
}
