
# Contributing to OpenSign

Hello there! Thank you for considering contributing to OpenSign, the open-source alternative to DocuSign. OpenSign is not just a project, but a community endeavor that aims to create a robust, user-friendly, and secure electronic signature solution. Your contributions, irrespective of their size, are valuable in making this vision a reality.

## Hacktoberfest at OpenSign

We are excited to announce that OpenSign is participating in Hacktoberfest! Hacktoberfest is a month-long celebration of open source where contributors can earn swag by contributing to open source projects. It's a fantastic opportunity to contribute, learn, and engage with the community. We welcome contributions of all kinds, and we are looking forward to seeing your contributions!

### Hacktoberfest Guidelines

1. **Registration:** Ensure you have signed up for [Hacktoberfest](https://hacktoberfest.digitalocean.com/) before making contributions to qualify for rewards.
2. **Quality Standards:** Substantial contributions are encouraged. PRs with minor text edits or that are deemed as low effort by maintainers may be marked as "invalid" or "spam".
3. **Pull Requests:** Only pull requests submitted between October 1st and October 31st will count towards the event.
4. **Respect:** Adhere to our [Code of Conduct](CODE_OF_CONDUCT.md) and maintain a respectful and collaborative environment.

## Table of Contents

1. [Getting Started](#getting-started)
2. [Code of Conduct](#code-of-conduct)
3. [How Can I Contribute?](#how-can-i-contribute)
    - [Reporting Bugs](#reporting-bugs)
    - [Suggesting Enhancements](#suggesting-enhancements)
    - [Pull Requests](#pull-requests)
4. [Style Guidelines](#style-guidelines)
    - [Git Commit Messages](#git-commit-messages)
    - [JavaScript Style Guide](#javascript-style-guide)
5. [Community](#community)
6. [License](#license)

## Getting Started

- Fork the [OpenSign repository](https://github.com/OpenSignLabs/OpenSign) to your GitHub account.
- Clone your fork locally: `git clone https://github.com/your-username/OpenSign.git`
- Create a new branch for your contribution: `git checkout -b feature/your-feature-name`
- Make your contributions.
- Push your branch to your fork: `git push origin feature/your-feature-name`
- Create a Pull Request from your fork to the OpenSign repository.

## Code of Conduct

We expect all our contributors to adhere to the [Code of Conduct](CODE_OF_CONDUCT.md). Please read it thoroughly before contributing.

## How Can I Contribute?

### Reporting Bugs

- Check the [Issues](https://github.com/OpenSignLabs/OpenSign/issues) to see if the bug has already been reported. If it has, add any additional information in the comments.
- If the bug hasn’t been reported, create a new issue. Please provide as much information as possible to help maintainers reproduce the bug.

### Suggesting Enhancements

- Use the [Issues](https://github.com/OpenSignLabs/OpenSign/issues) section to suggest any enhancements or new features.
- Clearly describe your suggestion, explaining the problem it solves or the functionality it adds.

### Pull Requests

- Ensure any install or build dependencies are removed before the end of the layer when doing a build.
- Update the README.md with details of changes to the interface, this includes new environment variables, exposed ports, useful file locations, and container parameters.
- You may merge the Pull Request in once you have the sign-off of two other developers, or if you do not have permission to do that, you may request the second reviewer to merge it for you.

## Style Guidelines

### Git Commit Messages

- Use the present tense ("Add feature" not "Added feature")
- Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
- Limit the first line to 72 characters or less

### JavaScript Style Guide

Adhere to the [Standard JavaScript Style Guide](https://standardjs.com).

## Community

Engage with the community on our [Gitter Channel](https://gitter.im/OpenSignLabs/community) or join our monthly community calls. Details can be found on our [Community Page](COMMUNITY.md).

## License

By contributing, you agree that your contributions will be licensed under its [AGPL-V3 License](LICENSE).

---
